﻿function JClipboard(owner)
{
	var self = this,
	_owner = owner,
	_isOK = false,
	_doc = _owner.getDocument(),
	_clipboard = null,
	_clipboardId = null,
	_clipboardString = null;

	this.copy = doCopy;
	this.paste = doPaste;

	if (browser.isIE)
	{
		_clipboard = _doc.createElement('input');
		_clipboard.style.visibility = 'hidden';
//		_doc.body.appendChild(_clipboard);
		_isOK = true;
	}
	else
	if (browser.isGeckoBased)
	{
		try
		{
			netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
			_clipboardId = Components.interfaces.nsIClipboard;
			_clipboard = Components.classes['@mozilla.org/widget/clipboard;1'].getService(_clipboardId);
			_clipboardString = Components.classes['@mozilla.org/supports-string;1'].createInstance(Components.interfaces.nsISupportsString);
			_isOK = true;
		}
		catch (e)
		{
			_isOK = false;
		}
	}

	function doCopy(text)
	{
		if (!_isOK)
		{
			alert('Kopírování do clipboardu bohužel není v tomto prohlížeči funkční.');
			return;
		} 

		if (browser.isIE)
		{
			if (_clipboard.parentNode == null)
				_doc.body.appendChild(_clipboard);

			_clipboard.value = text;
			_clipboard.select();
			_clipboard.createTextRange().execCommand('Copy');
		}
		else
		if (browser.isGeckoBased)
		{
			netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
			_clipboardString.data = text;
			var transfer = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
			transfer.setTransferData('text/unicode', _clipboardString, text.length*2);
			_clipboard.setData(transfer, null, _clipboardId.kGlobalClipboard);
		}
	}

	function doPaste()
	{
		if (browser.isIE)
		{
			if (_clipboard.parentNode == null)
				_doc.body.appendChild(_clipboard);

			_clipboard.value = '';
			var textRange = _clipboard.createTextRange();
			textRange.execCommand('paste');

			return _clipboard.value;
		}
		else
		if (browser.isGeckoBased)
		{
			netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');
			var transfer = Components.classes['@mozilla.org/widget/transferable;1'].createInstance(Components.interfaces.nsITransferable);
			transfer.addDataFlavor('text/unicode');
			_clipboard.getData(transfer, _clipboardId.kGlobalClipboard);
			var str = new Object();
			var strLength = new Object();
			transfer.getTransferData('text/unicode', str, strLength);
			str = str.value.QueryInterface(Components.interfaces.nsISupportsString);

			return str.data.substring(0, strLength.value / 2);
		}
	}
	
}

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();